function [sigma_hat, b_hat] = main(samples,label)
% samples: dxn vector generated from D(W^*, b^*) for some non-negative b^*
[d, n] = size(samples);
b_hat = zeros(d,1);
% estimate the row norms of W^* and b^*
if label == "GD w/o Filter" || label == "Oracle GD" || label == "GD with Median" || label == "GD with Trimmed Mean"
    [b_hat, sigma_diag] = NormBiasEstGD(samples,label);
elseif label == "SGD w/o Filter" || label == "SGD with Median" || label == "SGD with Trimmed Mean" || label == "Oracle SGD"
    [b_hat, sigma_diag] = NormBiasEst(samples,label);
end
b_hat = max(0, b_hat);

% estimate the angles between any two row vectors of W^*
sigma_hat = diag(sigma_diag);
for i = 1:d
    for j = (i+1):d
        theta_hat = pi-2*pi*sum(double(samples(i,:)>b_hat(i)).*double(samples(j,:)>b_hat(j)))/n;
        sigma_hat(i,j) = sqrt(sigma_hat(i,i)*sigma_hat(j,j))*cos(theta_hat);
        sigma_hat(j,i) = sigma_hat(i,j);
    end
end 